<?PHP 
	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 
	$this->load->helper('form');
?>
				<h1>Reports</h1>
				<div class="column">
					<div id="tabs" class="column ui-tabs ui-widget ui-widget-content ui-corner-all">
						<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/requests">Requests</a></li>
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/events">Events</a></li>
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/logins">Logins</a></li>
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/mail">Mail</a></li>
							<li class="reports-tab ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="/reports/tickets">Tickets</a></li>
						</ul>
					<div class="tab-content">
						<p>This report shows the submitted support tickets.</p>
						<?PHP echo form_open('/reports/tickets',array('id'=>'reports_form','onsubmit'=>"javascript:submitPaginationForm('', this.value, ".$form_data['items_per_page'].", '');")); ?>
							<table class="form">
								<tr class="form_row">
									<td>Category:</td>
									<td>
										<select class="fill_row" id="ticket_category" name="ticket_category" onkeydown="if(event.keyCode == 13){this.form.submit();return false;}">
											<option value="(ALL)">(ALL)</option>
											<?php foreach($categories as $cat){ ?>
											<option value="<?php echo $cat->id;?>" <?php if (isset($form_data['ticket_category']) && $cat->id==$form_data['ticket_category']){echo "selected";}?>><?php echo $cat->category;?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>
								<tr class="form_row">
									<td>ID:</td>
									<td>
										<p class="hidden_context">Help Text for ID: Table ID of Tickets</p>
										<input class="ttFocus" title="Table ID of Tickets" id = "ticket_id" name = "ticket_id" type = "text" value = "<?php if(isset($form_data['ticket_id'])) { echo $form_data['ticket_id']; } ?>" onkeydown = "if(event.keyCode == 13){$('#ticket_id').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label class="hidden_context">Compare options for ID</label>
										<select id="ticket_id_type" name = "ticket_id_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if (isset($form_data['ticket_id_type']) && $key == $form_data['ticket_id_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>									
									<td>Parent:</td>
									<td>
										<p class="hidden_context">Help Text for Parent: The ID of the parent ticket</p>
										<input class="ttFocus" title="The ID of the parent ticket" id="ticket_parent" name="ticket_parent" type="text" value="<?php if(isset($form_data['ticket_parent'])) { echo $form_data['ticket_parent']; } ?>" onkeydown="if(event.keyCode == 13){$('#ticket_parent').onfocus = function(){this.form.submit();return false;}}"></input>								
									</td>
									<td>
										<label class="hidden_context">Compare options for Parent</label>
										<select id="ticket_parent_type" name = "ticket_parent_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if (isset($form_data['ticket_parent_type']) && $key == $form_data['ticket_parent_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>								
								<tr class="form_row">
									<td>User:</td>
									<td>
										<p class="hidden_context">Help Text for User: The user who submitted the support ticket</p>
										<input class="ttFocus" title="The user who submitted the support ticket" id="ticket_user" name="ticket_user" type="text" value="<?php if(isset($form_data['ticket_user'])) { echo $form_data['ticket_user']; } ?>" onkeydown="if(event.keyCode == 13){$('#ticket_user').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label class="hidden_context">Compare options for User</label>
										<select id="ticket_user_type" name="ticket_user_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if (isset($form_data['ticket_user_type']) && $key==$form_data['ticket_user_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>									
									<td>Message:</td>
									<td>
										<p class="hidden_context">Help Text for Message: The content of the support ticket</p>
										<input class="ttFocus" title="The content of the support ticket" id="ticket_message" name="ticket_message" type="text" value="<?php if(isset($form_data['ticket_message'])) { echo $form_data['ticket_message']; } ?>" onkeydown="if(event.keyCode == 13){$('#ticket_message').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label class="hidden_context">Compare options for Message</label>
										<select id="ticket_message_type" name = "ticket_message_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if (isset($form_data['ticket_message_type']) && $key == $form_data['ticket_message_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>								
								<tr class="form_row">
									<td>Start Open Date:</td>
									<td><input type="text" id="open_start_date" name="open_start_date" class="date" value="<?php if(isset($form_data['open_start_date'])) { echo $form_data['open_start_date']; } ?>" onkeydown="if(event.keyCode == 13){$('#open_start_date').onfocus=function(){this.form.submit();return false;}}"/></td>
									<td>&nbsp;</td>
									<td>End Open Date:</td>
									<td><input type="text" id="open_end_date" name="open_end_date" class="date" value="<?php if(isset($form_data['open_end_date'])) { echo $form_data['open_end_date']; } ?>" onkeydown="if(event.keyCode == 13){$('#open_end_date').onfocus = function(){this.form.submit();return false;}}"/></td>
								</tr>								
								<tr class="form_row">
									<td>Start Close Date:</td>
									<td><input type="text" id="close_start_date" name="close_start_date" class="date" value="<?php if(isset($form_data['close_start_date'])) { echo $form_data['close_start_date']; } ?>" onkeydown="if(event.keyCode == 13){$('#close_start_date').onfocus=function(){this.form.submit();return false;}}"/></td>
									<td>&nbsp;</td>
									<td>End Close Date:</td>
									<td><input type="text" id="close_end_date" name="close_end_date" class="date" value="<?php if(isset($form_data['close_end_date'])) { echo $form_data['close_end_date']; } ?>" onkeydown="if(event.keyCode == 13){$('#close_end_date').onfocus = function(){this.form.submit();return false;}}"/></td>
								</tr>
								<script>$('input.date').datetimepicker({timeFormat: "hh:mm tt"});</script>
							</table>
							<?PHP
								$hidden_inputs = array(
									'order' => isset($form_data['order']) ? $form_data['order'] : '',
									'direction' => isset($form_data['direction']) ? $form_data['direction'] : '',
									'lastorder' => isset($form_data['order']) ? $form_data['order']  : '',
									'change' => 'false',
									'export' => '0',
									'page_on_bar' => '',
									'items_per_page' => ITEMS_PER_PAGE_DEFAULT,
								);
								echo form_hidden($hidden_inputs,TRUE);
							?>
							<div class="center">
								<input class="blue-button" id="filter_button" name="filter_button" type="submit" value="Filter"></input>
								<input class="blue-button" id="clear_button" name="clear_button" type="button" value="Clear" onclick="$('#clear_form').submit();"></input>
							</div>
							<?php if (sizeof($ticket_list) != 0) { ?>
								<div class="pagination">
									<?php echo $form_data['pages']->display_result_num();?>
									<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
									<?php echo $form_data['pages']->display_items_per_page();?>
									<div style="float:right; position:relative">
										<img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" onclick="$('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');" />
										<label class="hidden_context">Page Selector</label>
										<select id="page_select" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '');" >
											<?php for($count = 1;$count <= $form_data['num_pages'];$count++){ ?>
											<option value="<?php echo $count;?>" <?php if ($count == $form_data['cur_page']){echo "selected";}?>><?php echo $count;?></option>
											<?php  } ?>
										</select>
										<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
									</div>
								</div>
							<?php } ?>
						<?PHP echo form_close(); ?>
						<?PHP echo form_open('/reports/tickets',array('id'=>'clear_form')); ?><?PHP echo form_close(); ?>
						<?php if (sizeof($ticket_list) == 0) { ?>
							<div class="message">There are currently no submitted support tickets.</div>
						<?php }else{ ?>
							<table class="display">	
								<tr class="report_row">
									<th width="5%"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','id');$('#change').attr('value','true');$('#reports_form').submit();">ID<?php  if(isset($form_data['order'])&&$form_data['order'] == 'id'){echo $image;} ?></a></th>
									<th width="10%"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','parent_id');$('#change').attr('value','true');$('#reports_form').submit();">Parent<?php  if(isset($form_data['order'])&&$form_data['order'] == 'parent_id'){ echo $image; } ?></a></th>
									<th width="10%"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','user_id');$('#change').attr('value','true');$('#reports_form').submit();">User<?php  if(isset($form_data['order'])&&$form_data['order'] == 'user_id'){ echo $image; } ?></a></th>
									<th width="15%"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','open_date');$('#change').attr('value','true');$('#reports_form').submit();">Open Date (<?php echo $timezone_abbr; ?>)<?php  if(isset($form_data['order'])&&$form_data['order'] == 'open_date'){ echo $image; } ?></a></th>
									<th width="15%"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','close_date');$('#change').attr('value','true');$('#reports_form').submit();">Close Date (<?php echo $timezone_abbr; ?>)<?php  if(isset($form_data['order'])&&$form_data['order'] == 'close_date'){echo $image; } ?></a></th>
									<th width="35%"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','message');$('#change').attr('value','true');$('#reports_form').submit();">Message<?php  if(isset($form_data['order'])&&$form_data['order'] == 'message'){ echo $image; } ?></a></th>
									<th width="10%" class="displaylast"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','category_id');$('#change').attr('value','true');$('#reports_form').submit();">Category<?php  if(isset($form_data['order'])&&$form_data['order'] == 'category_id'){ echo $image; } ?></a></th>
								</tr>
								<?php foreach($ticket_list as $ticket){ ?>
									<tr class="report_row">
										<td class="break-word"><?php echo $ticket->id; ?></td>
										<td class="break-word"><?php echo $ticket->parent_id; ?></td>
										<td class="break-word"><?php echo $ticket->user_id; ?></td>
										<td class="break-word"><?php echo $ticket->open_date; ?></td>
										<td class="break-word"><?php echo $ticket->close_date; ?></td>
										<td class="break-word"><?php echo $ticket->message; ?></td>
										<td class="break-word"><?php echo $ticket->category_id; ?></td>
									</tr>
								<?php  } ?>
							</table>
							
							<div class="pagination">
								<?php echo $form_data['pages']->display_result_num();?>
								<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
								<?php echo $form_data['pages']->display_items_per_page();?>
								<div style="float:right; position:relative">
									<img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" onclick="$('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');" />
									<label class="hidden_context">Page Selector</label>
									<select id="page_select" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '');" >
										<?php for($count = 1;$count <= $form_data['num_pages'];$count++){ ?>
										<option value="<?php echo $count;?>" <?php if ($count == $form_data['cur_page']){echo "selected";}?>><?php echo $count;?></option>
										<?php  } ?>
									</select>
									<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
								</div>
							</div>
						
						<?php } ?>
						</div>
					</div>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>